package gov.va.med.mhv.sm.web.form;

import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.TriageGroup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StaffOrTriageVO {
	private String name;
	private String id;
	
	public static final String CLINICIAN_TYPE = "1|";
	public static final String TRIAGE_GROUP_TYPE = "2|";
	
	public StaffOrTriageVO() {
	}
	
	public StaffOrTriageVO(String id, String name) {
		this.id=id;
		this.name=name;
	}
	
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static List<StaffOrTriageVO> createFolderVOList( Collection<Clinician> cl, Collection<TriageGroup> tg ) {
		List<StaffOrTriageVO> list = new ArrayList<StaffOrTriageVO>();
		
		for(Clinician c:cl) {
			list.add(new StaffOrTriageVO(CLINICIAN_TYPE+c.getId(),c.getFullName()+" (staff)"));
		}
		for(TriageGroup t:tg) {
			list.add(new StaffOrTriageVO(TRIAGE_GROUP_TYPE+t.getId(),t.getName()+" (triage)"));
		}
		
		return list;
	}
	
	public static ParticipantTypeEnum resolveType( String id ) {
		if( id.startsWith(CLINICIAN_TYPE)) {
			return ParticipantTypeEnum.CLINICIAN;
		} else if( id.startsWith(TRIAGE_GROUP_TYPE)) {
			return ParticipantTypeEnum.TRIAGE_GROUP;
		}
		return null;
	}
	
	public static Clinician findClinician( Long id, Collection<Clinician> cl ) {
		for(Clinician c:cl) {
			if( id.equals(c.getId()) ) {
				return c;
			}
		}
		return null;
	}
	
	public static TriageGroup findTriageGroup( Long id, Collection<TriageGroup> tg ) {
		for(TriageGroup t:tg) {
			if( id.equals(t.getId()) ) {
				return t;
			}
		}
		return null;
	}
	
	public static String getClinicianValueForId( Long id ) {
		return CLINICIAN_TYPE+id;
	}
	
	public static String getTriageGroupValueForId( Long id ) {
		return TRIAGE_GROUP_TYPE+id;
	}
	
}
